<?php
/**
 * WPAchievements Uninstall
 *
 * Uninstalling WPAchievements deletes user data, tables, and options.
 *
 * @package WPAchievements\Uninstaller
 * @version 1.0.0
 */

defined( 'WP_UNINSTALL_PLUGIN' ) || exit;

global $wpdb, $wp_version;

/*
 * Only remove ALL data if WPACHIEVEMENTS_REMOVE_ALL_DATA constant is set to true in user's
 * wp-config.php. This is to prevent data loss when deleting the plugin from the backend
 * and to ensure only the site owner can perform this action.
 */
if ( defined( 'WPACHIEVEMENTS_REMOVE_ALL_DATA' ) && true === WPACHIEVEMENTS_REMOVE_ALL_DATA ) {

  // Clear hooks
  wp_clear_scheduled_hook( 'wpachievements_tracker_send_event' );

  if ( is_multisite() ) {
    delete_blog_option( 1,'wpachievements_achievements_data' );
    delete_blog_option( 1,'wpachievements_ranks_data' );
    delete_blog_option( 1,'wpach_of_template' );
    delete_blog_option( 1,'wpach_of_shortname' );

    $table = $wpdb->get_blog_prefix(1) . 'wpachievements_activity';
  }
  else{
    delete_option( 'wpachievements_achievements_data' );
    delete_option( 'wpachievements_ranks_data' );
    delete_option( 'wpach_of_template' );
    delete_option( 'wpach_of_shortname' );

    $table = $wpdb->prefix.'achievements';
  }

  // Delete posts and data
  $wpdb->query( "DELETE FROM {$wpdb->posts} WHERE post_type IN ( 'wpachievements', 'wpquests' );" );
  $wpdb->query( "DELETE meta FROM {$wpdb->postmeta} meta LEFT JOIN {$wpdb->posts} posts ON posts.ID = meta.post_id WHERE posts.ID IS NULL;" );

  // Remove Activtiy Table
  $wpdb->query( "DROP TABLE IF EXISTS {$table}" );

  // Remove WPAchievements user meta
  $wpdb->query( "DELETE FROM $wpdb->usermeta WHERE meta_key LIKE 'achievements\_%';" );

  // Clear any cached data that has been removed.
  wp_cache_flush();
}